package com.iqsim.xiqs.utils;

import javax.swing.*;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.*;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

import java.io.StringReader;
import java.io.StringWriter;


//This class is used to add automatically a simple or a complex filter in the example command on UI. 
public class FilterToXMLAdder {
	
	 public static String addFilter(JTextArea textArea, String additionalString) {
		 try {
	            // Get JTextArea content
	            String xmlString = textArea.getText();

	            // Convertir la chaîne XML en Document
	            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
	            DocumentBuilder builder = factory.newDocumentBuilder();
	            Document document = builder.parse(new InputSource(new StringReader(xmlString)));

	            // Retrieve <command> attribute and check if contains name attribute
	            NodeList commandNodes = document.getElementsByTagName("command");
	            if (commandNodes.getLength() > 0) {
	                Element commandElement = (Element) commandNodes.item(0);
	                String commandName = commandElement.getAttribute("name");

	                // Check if name attribut ends by "list", because filters can be applyed only on get...list command
	                if (commandName.endsWith("List")) {
	                    // get all "params" attributes
	                    NodeList paramNodes = commandElement.getElementsByTagName("param");
	                    if (paramNodes.getLength() > 0) {
	                        Element lastParamElement = (Element) paramNodes.item(paramNodes.getLength() - 1);

	                        // Add filter after last <param> elements
	                        Node additionalTextNode = document.createTextNode(additionalString);
	                        commandElement.insertBefore(additionalTextNode, lastParamElement.getNextSibling());
	                    } else {
	                        // if no <param> element, add filter in command <command>
	                        Node additionalTextNode = document.createTextNode(additionalString);
	                        commandElement.appendChild(additionalTextNode);
	                    }
	                } 
	            }

	            // Code use to pretty print xml
	            TransformerFactory transformerFactory = TransformerFactory.newInstance();
	            Transformer transformer = transformerFactory.newTransformer();
	            transformer.setOutputProperty(OutputKeys.INDENT, "yes");
	            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");

	            // Transform xml characters into classic text characters
	            StringWriter writer = new StringWriter();
	            transformer.transform(new DOMSource(document), new StreamResult(writer));
	            String formattedXml = writer.toString().replaceAll("&lt;", "<").replaceAll("&gt;", ">")
	                    .replaceAll("&apos;", "'").replaceAll("&quot;", "\"")
	                    .replaceAll("&amp;", "&");;

	            return formattedXml;
	        } catch (Exception e) {
	            e.printStackTrace();
	            
	        }
		return "";
	 }
}
