package com.iqsim.xiqs.utils;

import java.io.*;
import java.nio.file.*;
import java.util.*;
import java.util.regex.*;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;


public class JavaFileToXML {

	  public static String generateXMLFromFile(String filePath) throws IOException, ParserConfigurationException, TransformerException {
	        // Read file content
	        List<String> lines = Files.readAllLines(Paths.get(filePath));
	        
	        // Analyse class name and field name and attributes
	        String className = null;
	        List<FieldInfo> fields = new ArrayList<>();
	        
	        Pattern classPattern = Pattern.compile("public class (\\w+)");
	        Pattern fieldPattern = Pattern.compile("private (\\w+) (_\\w+);");
	        
	        for (String line : lines) {
	            Matcher classMatcher = classPattern.matcher(line);
	            if (classMatcher.find()) {
	                className = classMatcher.group(1);
	            }

	            Matcher fieldMatcher = fieldPattern.matcher(line);
	            if (fieldMatcher.find()) {
	                String type = fieldMatcher.group(1).toLowerCase();
	                String name = fieldMatcher.group(2);
	                fields.add(new FieldInfo(type, name));
	            }
	        }
	        
			//If no classname, it's not a Java class
	        if (className == null) {
	            throw new IllegalArgumentException("Invalid Java Class File.");
	        }

	        // Generate XML document
	        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
	        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
	        Document doc = docBuilder.newDocument();

	        // "command" element is used as root element
	        Element rootElement = doc.createElement("command");
	        rootElement.setAttribute("name", className);
	        doc.appendChild(rootElement);

	        // add parameters
	        for (FieldInfo field : fields) {
	            Element paramElement = doc.createElement("param");
	            paramElement.setAttribute("type", field.getType());
	            paramElement.appendChild(doc.createTextNode(field.getName()));
	            rootElement.appendChild(paramElement);
	        }

	        // Code used  to transform document into string
	        TransformerFactory transformerFactory = TransformerFactory.newInstance();
	        Transformer transformer = transformerFactory.newTransformer();
	        transformer.setOutputProperty(OutputKeys.INDENT, "yes");
	        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
	        DOMSource source = new DOMSource(doc);

	        StringWriter writer = new StringWriter();
	        StreamResult result = new StreamResult(writer);

	        transformer.transform(source, result);

	        return writer.toString();
	    }

		//Utils class to help analyse for java class variable
	    static class FieldInfo {
	        private String type;
	        private String name;

	        public FieldInfo(String type, String name) {
	            this.type = type;
	            this.name = name;
	        }

	        public String getType() {
	            return type;
	        }

	        public String getName() {
	            return name;
	        }
	    }

}
