package com.iqsim.xiqs.utils;

public class SimpleFilter {
	
	//Refer to simple filter documention 
	private int start = 0;
	private int limit = 0;
    private DIR dir;
    private SORT sort;
    private String query = "";
    
    public SimpleFilter() {
    	
    }
	
    public SimpleFilter(int start, int limit, DIR dir, SORT sort, String query) {
		this.start = start;
		this.limit = limit;
		this.dir = dir;
		this.sort = sort;
		this.query = query;
	}
    
    
	public int getStart() {
		return start;
	}
	public void setStart(int start) {
		this.start = start;
	}
	public int getLimit() {
		return limit;
	}
	public void setLimit(int limit) {
		this.limit = limit;
	}
	public DIR getDir() {
		return dir;
	}
	public void setDir(DIR dir) {
		this.dir = dir;
	}
	public SORT getSort() {
		return sort;
	}
	public void setSort(SORT sort) {
		this.sort = sort;
	}
	public String getQuery() {
		return query;
	}
	public void setQuery(String query) {
		this.query = query;
	}
	

	//Return this object in XML format to add it into command
	@Override
	public String toString() {
		
		StringBuilder builder = new StringBuilder();
	    builder.append("<simplefilter>")
	      .append("<start>").append(this.start).append("</start>\n")
	      .append("<limit>").append(this.limit).append("</limit>\n")
	      .append("<DIR>").append(this.dir).append("</DIR>\n")
	      .append("<SORT>").append(this.sort).append("</SORT>\n")
	      .append("<query>'").append(this.query).append("</query>\n")
	      .append("</simplefilter>");
	    
	    return builder.toString();
				
	}
	
	
	//This static method is used to return a sample simple filter
	// if used, you must replace all __VALUE__ string by correct value
	public static String sampleString() {
		
	    StringBuilder builder = new StringBuilder();
	    builder.append("<simplefilter>\n")
	      .append("<start>").append("_VALUE_").append("</start>\n")
	      .append("<limit>").append("_VALUE_").append("</limit>\n")
	      .append("<DIR>").append("_VALUE_").append("</DIR>\n")
	      .append("<SORT>").append("_VALUE_").append("</SORT>\n")
	      .append("<query>").append("_VALUE_").append("</query>\n")
	      .append("</simplefilter>");
	      
	    return builder.toString();
		
	}
	

}
