/*
 * Decompiled with CFR 0.152.
 */
package com.iqsim.xiqs;

import com.iqsim.xiqs.XmlSenderService;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api"})
public class FileUploadController {
    @Autowired
    private XmlSenderService xmlSenderService;

    @PostMapping(value={"/upload"})
    public String uploadFiles(@RequestParam(value="login") String login, @RequestParam(value="password") String password, @RequestParam(value="xmlFiles") List<MultipartFile> xmlFiles) {
        if (!"validLogin".equals(login) || !"validPassword".equals(password)) {
            return "Invalid login or password";
        }
        String host = "server-hostname";
        int port = 12345;
        for (MultipartFile xmlFile : xmlFiles) {
            File file = this.convertMultipartFileToFile(xmlFile);
            try {
                this.xmlSenderService.sendXml(host, port, file);
            }
            catch (IOException e) {
                e.printStackTrace();
                return "Error sending file: " + xmlFile.getOriginalFilename();
            }
        }
        return "Files uploaded successfully";
    }

    private File convertMultipartFileToFile(MultipartFile multipartFile) {
        try {
            File convFile = new File(System.getProperty("java.io.tmpdir") + "/" + multipartFile.getOriginalFilename());
            multipartFile.transferTo(convFile);
            return convFile;
        }
        catch (IOException e) {
            throw new RuntimeException("Error converting MultipartFile to File", e);
        }
    }
}

