/*
 * Decompiled with CFR 0.152.
 */
package com.iqsim.xiqs;

import com.iqsim.xiqs.interfaces.ServerResultListener;
import com.iqsim.xiqs.utils.ClientSocketHandler;
import com.iqsim.xiqs.utils.ComplexFilter;
import com.iqsim.xiqs.utils.FilterToXMLAdder;
import com.iqsim.xiqs.utils.JavaFileToXML;
import com.iqsim.xiqs.utils.SimpleFilter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

public class FileUploadGUI
extends JFrame
implements ServerResultListener {
    private static final long serialVersionUID = -5974513049103332752L;
    private JTextField loginField;
    private JPasswordField passwordField;
    private JTextField ipField;
    private JTextField portField;
    private DefaultListModel<File> fileListModel;
    private JList<File> fileList;
    private JTextArea xmlContentArea;
    private JTextArea responseArea;
    private JCheckBox autoLoginCheckBox;
    private Properties config = new Properties();
    private ClientSocketHandler clientSocketHandler;
    private static final String CONFIG_FILE = "config.properties";

    public FileUploadGUI() {
        this.loadConfig();
        this.setTitle("XIQS API Tester Java Version");
        this.setSize(1024, 768);
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        this.loginField = new JTextField(20);
        this.passwordField = new JPasswordField(20);
        this.ipField = new JTextField(20);
        this.portField = new JTextField(20);
        this.xmlContentArea = new JTextArea(10, 50);
        this.responseArea = new JTextArea(10, 50);
        this.responseArea.setEditable(false);
        this.autoLoginCheckBox = new JCheckBox("Auto Login");
        JButton xmlfileButton = new JButton("Select a .XML file");
        JButton javaFileButton = new JButton("Select a .java file");
        JButton sendButton = new JButton("Send to server");
        this.fileListModel = new DefaultListModel();
        this.fileList = new JList<File>(this.fileListModel);
        this.fileList.setSelectionMode(0);
        this.fileList.addListSelectionListener(e -> this.loadSelectedFileContent());
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        panel.add((Component)this.autoLoginCheckBox, c);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        panel.add((Component)new JLabel("Login:"), c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        panel.add((Component)this.loginField, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        panel.add((Component)new JLabel("Password:"), c);
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        panel.add((Component)this.passwordField, c);
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 0.0;
        panel.add((Component)new JLabel("IP Adress:"), c);
        c.gridx = 1;
        c.gridy = 2;
        c.weightx = 1.0;
        panel.add((Component)this.ipField, c);
        c.gridx = 0;
        c.gridy = 3;
        c.weightx = 0.0;
        panel.add((Component)new JLabel("Port:"), c);
        c.gridx = 1;
        c.gridy = 3;
        c.weightx = 1.0;
        panel.add((Component)this.portField, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 0;
        panel.add((Component)this.autoLoginCheckBox, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 0;
        panel.add((Component)xmlfileButton, c);
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 1;
        panel.add((Component)javaFileButton, c);
        c.gridx = 0;
        c.gridy = 7;
        c.gridwidth = 2;
        c.fill = 1;
        c.weighty = 0.5;
        panel.add((Component)new JScrollPane(this.fileList), c);
        c.gridx = 0;
        c.gridy = 8;
        c.gridwidth = 2;
        c.weighty = 1.0;
        panel.add((Component)new JScrollPane(this.xmlContentArea), c);
        final JPopupMenu popupMenuRequestFilter = new JPopupMenu();
        JMenuItem simpleFilterOption = new JMenuItem("Add simple filter example");
        simpleFilterOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileUploadGUI.this.xmlContentArea.setText(FilterToXMLAdder.addFilter(FileUploadGUI.this.xmlContentArea, SimpleFilter.sampleString()));
            }
        });
        JMenuItem complexFilterOption = new JMenuItem("Add complex filter example");
        complexFilterOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileUploadGUI.this.xmlContentArea.setText(FilterToXMLAdder.addFilter(FileUploadGUI.this.xmlContentArea, ComplexFilter.sampleString()));
            }
        });
        popupMenuRequestFilter.add(complexFilterOption);
        popupMenuRequestFilter.add(simpleFilterOption);
        this.xmlContentArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popupMenuRequestFilter.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        c.gridx = 0;
        c.gridy = 9;
        c.gridwidth = 2;
        c.weighty = 0.0;
        panel.add((Component)sendButton, c);
        c.gridx = 0;
        c.gridy = 10;
        c.gridwidth = 2;
        c.weighty = 1.0;
        panel.add((Component)new JScrollPane(this.responseArea), c);
        final JPopupMenu popupMenuResponseFormat = new JPopupMenu();
        JMenuItem eraseResponse = new JMenuItem("Erase");
        eraseResponse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileUploadGUI.this.responseArea.setText("");
            }
        });
        popupMenuResponseFormat.add(eraseResponse);
        this.responseArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popupMenuResponseFormat.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.add(panel);
        this.fillFieldsFromConfig();
        xmlfileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setMultiSelectionEnabled(true);
                int returnValue = fileChooser.showOpenDialog(null);
                if (returnValue == 0) {
                    File[] files;
                    File[] fileArray = files = fileChooser.getSelectedFiles();
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        FileUploadGUI.this.fileListModel.addElement(file);
                        ++n2;
                    }
                }
            }
        });
        javaFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setFileSelectionMode(0);
                int returnValue = fileChooser.showOpenDialog(null);
                if (returnValue == 0) {
                    File selectedFile = fileChooser.getSelectedFile();
                    try {
                        String transformedJavaCode = JavaFileToXML.generateXMLFromFile(selectedFile.getAbsolutePath());
                        FileUploadGUI.this.xmlContentArea.setText(transformedJavaCode);
                    }
                    catch (IOException | ParserConfigurationException | TransformerException ex) {
                        FileUploadGUI.this.showError(ex);
                    }
                }
            }
        });
        sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String login = FileUploadGUI.this.loginField.getText();
                String password = new String(FileUploadGUI.this.passwordField.getPassword());
                String ip = FileUploadGUI.this.ipField.getText();
                int port = Integer.parseInt(FileUploadGUI.this.portField.getText());
                FileUploadGUI.this.updateConfig(login, password, ip, port, FileUploadGUI.this.autoLoginCheckBox.isSelected());
                if (FileUploadGUI.this.clientSocketHandler != null) {
                    try {
                        FileUploadGUI.this.clientSocketHandler.initSocket(ip, port);
                        Thread socketThread = new Thread(FileUploadGUI.this.clientSocketHandler);
                        socketThread.start();
                    }
                    catch (IOException e1) {
                        FileUploadGUI.this.showError(e1);
                    }
                }
                if (FileUploadGUI.this.autoLoginCheckBox.isSelected()) {
                    String loginRequest = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><command name=\"loginXIQS\">  <param type=\"string\">" + login + "</param>  <param type=\"string\">" + password + "</param></command>";
                    FileUploadGUI.this.clientSocketHandler.sendRequest(loginRequest);
                }
                String request = FileUploadGUI.this.xmlContentArea.getText();
                FileUploadGUI.this.clientSocketHandler.sendRequest(request);
            }
        });
        try {
            this.clientSocketHandler = new ClientSocketHandler();
            this.clientSocketHandler.setListener(this);
        }
        catch (NumberFormatException ex) {
            this.showError(ex);
        }
    }

    private void loadSelectedFileContent() {
        File selectedFile = this.fileList.getSelectedValue();
        if (selectedFile != null) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(selectedFile));
                this.xmlContentArea.read(reader, null);
                reader.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.showError(ex);
            }
        }
    }

    private void loadConfig() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileInputStream input = new FileInputStream(CONFIG_FILE);){
                this.config.load(input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            this.showError(ex);
        }
    }

    private void fillFieldsFromConfig() {
        this.loginField.setText(this.config.getProperty("login", ""));
        this.passwordField.setText(this.config.getProperty("password", ""));
        this.ipField.setText(this.config.getProperty("ip", ""));
        this.portField.setText(this.config.getProperty("port", ""));
        this.autoLoginCheckBox.setSelected(Boolean.parseBoolean(this.config.getProperty("autoLogin", "false")));
    }

    private void updateConfig(String login, String password, String ip, int port, boolean autoLogin) {
        this.config.setProperty("login", login);
        this.config.setProperty("password", password);
        this.config.setProperty("ip", ip);
        this.config.setProperty("port", String.valueOf(port));
        this.config.setProperty("autoLogin", String.valueOf(autoLogin));
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileOutputStream output = new FileOutputStream(CONFIG_FILE);){
                this.config.store(output, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            this.showError(ex);
        }
    }

    private void showError(Exception e) {
        JOptionPane.showMessageDialog(null, "An error occured :  " + e.getMessage(), "Error", 0);
    }

    @Override
    public void onServerResponse(final String response) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileUploadGUI.this.responseArea.append(response + "\n");
            }
        });
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new FileUploadGUI().setVisible(true);
            }
        });
    }
}

