/*
 * Decompiled with CFR 0.152.
 */
package com.iqsim.xiqs.utils;

import com.iqsim.xiqs.interfaces.ServerResultListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ClientSocketHandler
implements Runnable {
    private Socket socket;
    private OutputStream out;
    private InputStream in;
    private final Lock lock = new ReentrantLock();
    private volatile boolean running = true;
    private ServerResultListener listener;

    public ClientSocketHandler() {
    }

    public ClientSocketHandler(String serverAddress, int port) throws IOException {
        this.socket = new Socket(serverAddress, port);
        this.out = this.socket.getOutputStream();
        this.in = this.socket.getInputStream();
    }

    @Override
    public void run() {
        byte[] buffer = new byte[4096];
        System.out.println("Waiting for server response...");
        try {
            try {
                int bytesRead;
                while (this.running && !this.socket.isClosed() && (bytesRead = this.in.read(buffer)) != -1) {
                    String serverResponse = new String(buffer, 0, bytesRead);
                    System.out.println("Server: " + serverResponse);
                    if (this.listener == null) continue;
                    this.listener.onServerResponse(serverResponse);
                }
                System.out.println("Stopped listening to server.");
            }
            catch (IOException e) {
                if (this.running) {
                    e.printStackTrace();
                }
                this.close();
            }
        }
        finally {
            this.close();
        }
    }

    public void sendRequest(String request) {
        this.lock.lock();
        try {
            try {
                this.out.write(request.getBytes());
                this.out.flush();
                System.out.println(request);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() {
        this.running = false;
        this.lock.lock();
        try {
            try {
                if (this.socket != null && !this.socket.isClosed()) {
                    this.socket.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setListener(ServerResultListener listener) {
        this.listener = listener;
    }

    public void initSocket(String serverAddress, int port) throws UnknownHostException, IOException {
        this.socket = new Socket(serverAddress, port);
        this.out = this.socket.getOutputStream();
        this.in = this.socket.getInputStream();
    }
}

