/*
 * Decompiled with CFR 0.152.
 */
package com.iqsim.xiqs.utils;

import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JavaFileToXML {
    public static String generateXMLFromFile(String filePath) throws IOException, ParserConfigurationException, TransformerException {
        List<String> lines = Files.readAllLines(Paths.get(filePath, new String[0]));
        String className = null;
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        Pattern classPattern = Pattern.compile("public class (\\w+)");
        Pattern fieldPattern = Pattern.compile("private (\\w+) (_\\w+);");
        for (String line : lines) {
            Matcher fieldMatcher;
            Matcher classMatcher = classPattern.matcher(line);
            if (classMatcher.find()) {
                className = classMatcher.group(1);
            }
            if (!(fieldMatcher = fieldPattern.matcher(line)).find()) continue;
            String type = fieldMatcher.group(1).toLowerCase();
            String name = fieldMatcher.group(2);
            fields.add(new FieldInfo(type, name));
        }
        if (className == null) {
            throw new IllegalArgumentException("Invalid Java Class File.");
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element rootElement = doc.createElement("command");
        rootElement.setAttribute("name", className);
        doc.appendChild(rootElement);
        for (FieldInfo field : fields) {
            Element paramElement = doc.createElement("param");
            paramElement.setAttribute("type", field.getType());
            paramElement.appendChild(doc.createTextNode(field.getName()));
            rootElement.appendChild(paramElement);
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(doc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.transform(source, result);
        return writer.toString();
    }

    static class FieldInfo {
        private String type;
        private String name;

        public FieldInfo(String type, String name) {
            this.type = type;
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }
    }
}

